/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.orm.persistor;

import com.jpattern.orm.mapper.clazz.IClassField;
import com.jpattern.orm.mapper.clazz.IClassMap;
import com.jpattern.orm.persistor.IOrmPersistor;
import com.jpattern.orm.persistor.IPersistorGenerator;
import com.jpattern.orm.persistor.PropertyPersistor;
import com.jpattern.orm.persistor.ReflectionOrmPersistor;
import com.jpattern.orm.persistor.type.JdbcIO;
import com.jpattern.orm.persistor.type.TypeFactory;
import com.jpattern.orm.persistor.type.TypeWrapper;
import com.jpattern.orm.persistor.version.NullVersionManipulator;
import com.jpattern.orm.persistor.version.VersionManipulator;
import com.jpattern.orm.persistor.version.VersionManipulatorImpl;
import com.jpattern.orm.persistor.version.VersionMath;
import com.jpattern.orm.persistor.version.VersionMathFactory;
import java.util.HashMap;
import java.util.Map;

public class ReflectionPersistorGenerator<BEAN>
implements IPersistorGenerator<BEAN> {
    private final IClassMap<BEAN> classMap;
    private final TypeFactory typeFactory;

    public ReflectionPersistorGenerator(IClassMap<BEAN> classMap, TypeFactory typeFactory) {
        this.classMap = classMap;
        this.typeFactory = typeFactory;
    }

    @Override
    public IOrmPersistor<BEAN> generate() throws Exception {
        Map<String, PropertyPersistor<BEAN, ?, ?>> propertyPersistorMap = this.getPropertyPersistorMap();
        return new ReflectionOrmPersistor<BEAN>(this.classMap, propertyPersistorMap, this.getVersionManipulator(propertyPersistorMap));
    }

    private <P, DB> Map<String, PropertyPersistor<BEAN, ?, ?>> getPropertyPersistorMap() throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, NoSuchFieldException {
        HashMap propertyPersistors = new HashMap();
        for (String columnJavaName : this.classMap.getAllColumnJavaNames()) {
            IClassField classField = this.classMap.getClassFieldByJavaName(columnJavaName);
            VersionMath versionMath = new VersionMathFactory().getMath(classField.getType(), classField.getVersionInfo().isVersionable());
            TypeWrapper typeWrapper = this.typeFactory.getTypeWrapper(classField.getType());
            JdbcIO jdbcIO = this.typeFactory.getJdbcIO(typeWrapper.jdbcType());
            propertyPersistors.put(columnJavaName, new PropertyPersistor(typeWrapper, jdbcIO, classField, versionMath));
        }
        return propertyPersistors;
    }

    private VersionManipulator<BEAN> getVersionManipulator(Map<String, PropertyPersistor<BEAN, ?, ?>> propertyPersistorMap) {
        VersionManipulator versionManipulator = new NullVersionManipulator();
        for (String columnJavaName : this.classMap.getAllColumnJavaNames()) {
            IClassField classField = this.classMap.getClassFieldByJavaName(columnJavaName);
            if (!classField.getVersionInfo().isVersionable()) continue;
            versionManipulator = new VersionManipulatorImpl<BEAN>(propertyPersistorMap.get(classField.getFieldName()));
            break;
        }
        return versionManipulator;
    }
}

