/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.orm.persistor;

import com.jpattern.orm.crud.AColumnValueGenerator;
import com.jpattern.orm.crud.ColumnValueGeneratorFactory;
import com.jpattern.orm.exception.OrmConfigurationException;
import com.jpattern.orm.exception.OrmReflectionException;
import com.jpattern.orm.mapper.clazz.ClassField;
import com.jpattern.orm.mapper.clazz.IClassField;
import com.jpattern.orm.mapper.clazz.IClassMap;
import com.jpattern.orm.persistor.IOrmPersistor;
import com.jpattern.orm.persistor.PropertyPersistor;
import com.jpattern.orm.persistor.generator.GeneratorManipulator;
import com.jpattern.orm.persistor.generator.GeneratorManipulatorImpl;
import com.jpattern.orm.persistor.generator.NullGeneratorManipulator;
import com.jpattern.orm.persistor.generator.ValueChecker;
import com.jpattern.orm.persistor.generator.ValueCheckerFactory;
import com.jpattern.orm.persistor.version.VersionManipulator;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Arrays;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectionOrmPersistor<BEAN>
implements IOrmPersistor<BEAN> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<String, PropertyPersistor<BEAN, ?, ?>> propertyPersistors;
    private GeneratorManipulator<BEAN> generatorManipulator = new NullGeneratorManipulator();
    private final IClassMap<BEAN> classMap;
    private final VersionManipulator<BEAN> versionManipulator;

    public ReflectionOrmPersistor(IClassMap<BEAN> classMap, Map<String, PropertyPersistor<BEAN, ?, ?>> propertyPersistors, VersionManipulator<BEAN> versionManipulator) throws OrmConfigurationException, SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, NoSuchFieldException {
        this.classMap = classMap;
        this.propertyPersistors = propertyPersistors;
        this.versionManipulator = versionManipulator;
        this.initGeneratorManipulator();
    }

    private <P> void initGeneratorManipulator() throws OrmConfigurationException, SecurityException, NoSuchMethodException {
        if (this.classMap.getAllGeneratedColumnJavaNames().length > 0) {
            String columnJavaName = this.classMap.getAllGeneratedColumnJavaNames()[0];
            IClassField column = this.classMap.getClassFieldByJavaName(columnJavaName);
            PropertyPersistor<BEAN, ?, ?> fieldManipulator = this.propertyPersistors.get(columnJavaName);
            AColumnValueGenerator generator = ColumnValueGeneratorFactory.getColumnValueGenerator((ClassField)this.classMap.getClassFieldByJavaName(columnJavaName), false);
            long[] validValues = generator.getActivateValues();
            ValueChecker valueChecker = ValueCheckerFactory.getValueChecker(column.getType());
            this.generatorManipulator = new GeneratorManipulatorImpl(fieldManipulator, valueChecker, validValues);
        }
    }

    @Override
    public BEAN mapRow(String rowNamePrefix, ResultSet rs, int rowNum) {
        String[] allColumnNames = this.classMap.getAllColumnJavaNames();
        try {
            BEAN entity = this.classMap.getMappedClass().newInstance();
            for (String columnJavaName : allColumnNames) {
                this.propertyPersistors.get(columnJavaName).getFromResultSet(entity, rs, rowNamePrefix);
            }
            return entity;
        }
        catch (Exception e) {
            throw new OrmReflectionException(e);
        }
    }

    @Override
    public BEAN clone(BEAN entity) {
        try {
            BEAN entityCopy = this.classMap.getMappedClass().newInstance();
            for (Map.Entry<String, PropertyPersistor<BEAN, ?, ?>> persistorEntry : this.propertyPersistors.entrySet()) {
                persistorEntry.getValue().clonePropertyValue(entity, entityCopy);
            }
            return entityCopy;
        }
        catch (Exception e) {
            throw new OrmReflectionException(e);
        }
    }

    @Override
    public Object[] allValues(BEAN entity) {
        return this.getValues(this.classMap.getAllColumnJavaNames(), entity);
    }

    @Override
    public void setAllValues(BEAN entity, PreparedStatement ps) {
        String[] columnNames = this.classMap.getAllColumnJavaNames();
        this.setValues(columnNames, entity, ps);
    }

    @Override
    public Object[] allNotGeneratedValues(BEAN entity) {
        return this.getValues(this.classMap.getAllNotGeneratedColumnJavaNames(), entity);
    }

    @Override
    public void setAllNotGeneratedValues(BEAN entity, PreparedStatement ps) {
        String[] columnNames = this.classMap.getAllNotGeneratedColumnJavaNames();
        this.setValues(columnNames, entity, ps);
    }

    @Override
    public Object[] primaryKeyValues(BEAN entity) {
        return this.getValues(this.classMap.getPrimaryKeyColumnJavaNames(), entity);
    }

    @Override
    public void setPrimaryKeyValues(BEAN entity, PreparedStatement ps) {
        String[] columnNames = this.classMap.getPrimaryKeyColumnJavaNames();
        this.setValues(columnNames, entity, ps);
    }

    @Override
    public Object[] notPrimaryKeyValues(BEAN entity) {
        return this.getValues(this.classMap.getNotPrimaryKeyColumnJavaNames(), entity);
    }

    @Override
    public void setNotPrimaryKeyValues(BEAN entity, PreparedStatement ps) {
        String[] columnNames = this.classMap.getNotPrimaryKeyColumnJavaNames();
        this.setValues(columnNames, entity, ps);
    }

    @Override
    public void setNotPrimaryKeyAndThenPrimaryKeyValues(BEAN entity, PreparedStatement ps) {
        String[] npkArgs = this.classMap.getNotPrimaryKeyColumnJavaNames();
        String[] pkArgs = this.classMap.getPrimaryKeyColumnJavaNames();
        String[] columns = new String[npkArgs.length + pkArgs.length];
        int i = 0;
        for (String value : npkArgs) {
            columns[i++] = value;
        }
        for (String value : pkArgs) {
            columns[i++] = value;
        }
        this.setValues(columns, entity, ps);
    }

    @Override
    public Object[] primaryKeyAndVersionValues(BEAN entity) {
        return this.getValues(this.classMap.getPrimaryKeyAndVersionColumnJavaNames(), entity);
    }

    @Override
    public void setPrimaryKeyAndVersionValues(BEAN entity, PreparedStatement ps) {
        String[] columnNames = this.classMap.getPrimaryKeyAndVersionColumnJavaNames();
        this.setValues(columnNames, entity, ps);
    }

    @Override
    public void increaseVersion(BEAN entity, boolean firstVersionNumber) {
        try {
            this.versionManipulator.updateVersion(entity, firstVersionNumber);
        }
        catch (Exception e) {
            throw new OrmReflectionException(e);
        }
    }

    @Override
    public boolean isVersionable() {
        return this.versionManipulator.isVersionable();
    }

    @Override
    public void updateGeneratedValues(ResultSet rs, BEAN entity) {
        String[] allColumnNames = this.classMap.getAllGeneratedColumnJavaNames();
        try {
            int i = 1;
            for (String columnJavaName : allColumnNames) {
                this.propertyPersistors.get(columnJavaName).getFromResultSet(entity, rs, i);
                ++i;
            }
        }
        catch (Exception e) {
            throw new OrmReflectionException(e);
        }
    }

    private Object[] getValues(String[] javaColumnNames, BEAN entity) {
        Object[] result = new Object[javaColumnNames.length];
        try {
            for (int i = 0; i < javaColumnNames.length; ++i) {
                String javaColumnName = javaColumnNames[i];
                result[i] = this.propertyPersistors.get(javaColumnName).getDBReadyValueFromBean(entity);
            }
        }
        catch (Exception e) {
            throw new OrmReflectionException(e);
        }
        return result;
    }

    @Override
    public boolean useKeyGenerators(BEAN entity) {
        try {
            return this.generatorManipulator.useGenerator(entity);
        }
        catch (Exception e) {
            throw new OrmReflectionException(e);
        }
    }

    @Override
    public boolean hasGenerators() {
        try {
            return this.generatorManipulator.hasGenerator();
        }
        catch (Exception e) {
            throw new OrmReflectionException(e);
        }
    }

    @Override
    public boolean hasConditionalGenerator() {
        try {
            return this.generatorManipulator.hasConditionalGenerator();
        }
        catch (Exception e) {
            throw new OrmReflectionException(e);
        }
    }

    private void setValues(String[] allColumnNames, BEAN entity, PreparedStatement ps) {
        try {
            Object[] allValues = this.getValues(allColumnNames, entity);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Query params: " + Arrays.toString(allValues));
            }
            for (int i = 0; i < allColumnNames.length; ++i) {
                PropertyPersistor<BEAN, ?, ?> persistor = this.propertyPersistors.get(allColumnNames[i]);
                persistor.setToPreparedStatement(allValues[i], ps, i + 1);
            }
        }
        catch (Exception e) {
            throw new OrmReflectionException(e);
        }
    }
}

