/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.orm.persistor;

import com.jpattern.orm.mapper.clazz.IClassField;
import com.jpattern.orm.persistor.type.JdbcIO;
import com.jpattern.orm.persistor.type.TypeWrapper;
import com.jpattern.orm.persistor.version.VersionMath;
import java.lang.reflect.InvocationTargetException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class PropertyPersistor<BEAN, P, DB> {
    private final JdbcIO<DB> jdbcIO;
    private final TypeWrapper<P, DB> typeWrapper;
    private final VersionMath<P> math;
    private final IClassField<BEAN, P> classField;

    public PropertyPersistor(TypeWrapper<P, DB> typeWrapper, JdbcIO<DB> jdbcIO, IClassField<BEAN, P> classField, VersionMath<P> math) {
        this.jdbcIO = jdbcIO;
        this.typeWrapper = typeWrapper;
        this.classField = classField;
        this.math = math;
    }

    public void setToPreparedStatement(DB value, PreparedStatement ps, int psIndex) throws IllegalArgumentException, SQLException, IllegalAccessException, InvocationTargetException {
        this.jdbcIO.setValueToPreparedStatement(value, ps, psIndex);
    }

    public void getFromResultSet(BEAN bean, ResultSet rs, String rsColumnNamePrefix) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, SQLException {
        this.setDBValueToBean(bean, this.jdbcIO.getValueFromResultSet(rs, rsColumnNamePrefix + this.classField.getColumnInfo().getDBColumnName()));
    }

    public void getFromResultSet(BEAN bean, ResultSet rs, int rsColumnIndex) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, SQLException {
        this.setDBValueToBean(bean, this.jdbcIO.getValueFromResultSet(rs, rsColumnIndex));
    }

    public void clonePropertyValue(BEAN source, BEAN destination) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        this.setPropertyValueToBean(destination, this.typeWrapper.clone(this.getPropertyValueFromBean(source)));
    }

    public void increaseVersion(BEAN bean, boolean firstVersionNumber) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        this.setPropertyValueToBean(bean, this.math.increase(firstVersionNumber, this.getPropertyValueFromBean(bean)));
    }

    public DB getDBReadyValueFromBean(BEAN bean) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        return this.typeWrapper.unWrap(this.getPropertyValueFromBean(bean));
    }

    public void setDBValueToBean(BEAN bean, DB value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        this.setPropertyValueToBean(bean, this.typeWrapper.wrap(value));
    }

    public P getPropertyValueFromBean(BEAN bean) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        return this.classField.getGetManipulator().getValue(bean);
    }

    public void setPropertyValueToBean(BEAN bean, P value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        this.classField.getSetManipulator().setValue(bean, value);
    }

    public Class<DB> jdbcType() {
        return this.typeWrapper.jdbcType();
    }

    public Class<P> propertyType() {
        return this.typeWrapper.propertyType();
    }

    public String getDbColumnName() {
        return this.classField.getColumnInfo().getDBColumnName();
    }
}

