/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.orm.mapper.clazz;

import com.jpattern.orm.annotation.Generator;
import com.jpattern.orm.annotation.Id;
import com.jpattern.orm.annotation.Ignore;
import com.jpattern.orm.annotation.column.ColumnInfoFactory;
import com.jpattern.orm.annotation.generator.GeneratorInfoFactory;
import com.jpattern.orm.annotation.table.TableInfo;
import com.jpattern.orm.annotation.table.TableInfoFactory;
import com.jpattern.orm.annotation.version.VersionInfoFactory;
import com.jpattern.orm.exception.OrmConfigurationException;
import com.jpattern.orm.mapper.clazz.ClassField;
import com.jpattern.orm.mapper.clazz.ClassMap;
import com.jpattern.orm.mapper.clazz.IClassField;
import com.jpattern.orm.mapper.clazz.IClassMap;
import com.jpattern.orm.mapper.clazz.IClassMapBuilder;
import com.jpattern.orm.persistor.reflection.FieldGetManipulator;
import com.jpattern.orm.persistor.reflection.FieldSetManipulator;
import com.jpattern.orm.persistor.reflection.GetManipulator;
import com.jpattern.orm.persistor.reflection.GetterGetManipulator;
import com.jpattern.orm.persistor.reflection.SetManipulator;
import com.jpattern.orm.persistor.reflection.SetterSetManipulator;
import com.jpattern.orm.util.FieldDefaultNaming;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassMapBuilder<BEAN>
implements IClassMapBuilder<BEAN> {
    private final Class<BEAN> clazz;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public ClassMapBuilder(Class<BEAN> clazz) {
        this.clazz = clazz;
    }

    @Override
    public IClassMap<BEAN> generate() {
        this.logger.info("generate " + IClassMap.class.getSimpleName() + " for Class " + this.clazz.getName());
        TableInfo tableInfo = TableInfoFactory.getTableInfo(this.clazz);
        this.logger.info("table name expected in relation with class " + this.clazz.getSimpleName() + ": " + tableInfo.getTableName() + " - schema: " + tableInfo.getSchemaName());
        ClassMap<BEAN> classMap = new ClassMap<BEAN>(this.clazz, tableInfo);
        this.initializeClassFields(classMap);
        this.initializeColumnNames(classMap);
        return classMap;
    }

    private void initializeClassFields(ClassMap<BEAN> classMap) {
        List<Method> methods = Arrays.asList(this.clazz.getMethods());
        List<Field> fields = this.getAllInheritedFields(this.clazz);
        for (Field field : fields) {
            if (field.isAnnotationPresent(Ignore.class) || Modifier.isStatic(field.getModifiers())) continue;
            classMap.addClassField(this.buildClassField(field, methods, field.getType()));
        }
    }

    private <P> ClassField<BEAN, P> buildClassField(Field field, List<Method> methods, Class<P> fieldClass) {
        ClassField<BEAN, P> classField = new ClassField<BEAN, P>(fieldClass, field.getName());
        classField.setColumnInfo(ColumnInfoFactory.getColumnInfo(field));
        classField.setGeneratorInfo(GeneratorInfoFactory.getGeneratorInfo(field));
        classField.setIdentifier(field.isAnnotationPresent(Id.class));
        classField.setVersionInfo(VersionInfoFactory.getVersionInfo(field));
        classField.setGetManipulator(this.getGetManipulator(field, methods, fieldClass));
        classField.setSetManipulator(this.getSetManipulator(field, methods, fieldClass));
        this.logger.info("DB column [" + classField.getColumnInfo().getDBColumnName() + "]" + " will be associated with object field [" + classField.getFieldName() + "]");
        return classField;
    }

    private <P> GetManipulator<BEAN, P> getGetManipulator(Field field, List<Method> methods, Class<P> clazz) {
        Method getter = null;
        String getterName = "";
        for (Method method : methods) {
            if (FieldDefaultNaming.getDefaultGetterName(field.getName()).equals(method.getName())) {
                getter = method;
                getterName = method.getName();
            }
            if (!FieldDefaultNaming.getDefaultBooleanGetterName(field.getName()).equals(method.getName())) continue;
            getter = method;
            getterName = method.getName();
        }
        this.logger.info("getter for property [" + field.getName() + "]: [" + getterName + "]");
        if (getter != null) {
            return new GetterGetManipulator(getter);
        }
        return new FieldGetManipulator(field);
    }

    private <P> SetManipulator<BEAN, P> getSetManipulator(Field field, List<Method> methods, Class<P> clazz) {
        Method setter = null;
        String setterName = "";
        for (Method method : methods) {
            if (!FieldDefaultNaming.getDefaultSetterName(field.getName()).equals(method.getName())) continue;
            setter = method;
            setterName = method.getName();
        }
        this.logger.info("setter for property [" + field.getName() + "]: [" + setterName + "]");
        if (setter != null) {
            return new SetterSetManipulator(setter);
        }
        return new FieldSetManipulator(field);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initializeColumnNames(ClassMap<BEAN> classMap) {
        this.logger.info("Start column analisys for Class ");
        ArrayList<String> allColumnJavaNamesList = new ArrayList<String>();
        ArrayList<String> allNotGeneratedColumnJavaNamesList = new ArrayList<String>();
        ArrayList<String> allGeneratedColumnJavaNamesList = new ArrayList<String>();
        ArrayList<String> allGeneratedColumnDBNamesList = new ArrayList<String>();
        ArrayList<String> primaryKeyColumnJavaNamesList = new ArrayList<String>();
        ArrayList<String> primaryKeyAndVersionColumnJavaNamesList = new ArrayList<String>();
        ArrayList<String> notPrimaryKeyColumnJavaList = new ArrayList<String>();
        boolean hasGenerator = false;
        for (Map.Entry<String, IClassField<BEAN, ?>> entry : classMap.getUnmodifiableFieldClassMap().entrySet()) {
            String javaFieldName = entry.getKey();
            allColumnJavaNamesList.add(javaFieldName);
            if (entry.getValue().isIdentifier()) {
                primaryKeyColumnJavaNamesList.add(javaFieldName);
                primaryKeyAndVersionColumnJavaNamesList.add(javaFieldName);
                this.logger.info("Field [" + javaFieldName + "] will be used as a Primary Key field");
            } else {
                notPrimaryKeyColumnJavaList.add(javaFieldName);
                this.logger.info("Field [" + javaFieldName + "] will be used as a normal field");
            }
            if (entry.getValue().getGeneratorInfo().isValid()) {
                if (hasGenerator) throw new OrmConfigurationException("A bean can have maximum one field annotated with @" + Generator.class.getSimpleName() + ". Error in class:[" + this.clazz.getCanonicalName() + "] field: [" + javaFieldName + "]");
                allGeneratedColumnJavaNamesList.add(javaFieldName);
                allGeneratedColumnDBNamesList.add(entry.getValue().getColumnInfo().getDBColumnName());
                this.logger.info("Field [" + javaFieldName + "] is an autogenerated field");
                hasGenerator = true;
            } else {
                allNotGeneratedColumnJavaNamesList.add(javaFieldName);
            }
            if (!entry.getValue().getVersionInfo().isVersionable()) continue;
            this.logger.info("Field [" + javaFieldName + "] is an version field");
            primaryKeyAndVersionColumnJavaNamesList.add(javaFieldName);
        }
        classMap.setAllColumnJavaNames(allColumnJavaNamesList.toArray(new String[0]));
        classMap.setAllNotGeneratedColumnJavaNames(allNotGeneratedColumnJavaNamesList.toArray(new String[0]));
        classMap.setAllGeneratedColumnJavaNames(allGeneratedColumnJavaNamesList.toArray(new String[0]));
        classMap.setAllGeneratedColumnDBNames(allGeneratedColumnDBNamesList.toArray(new String[0]));
        classMap.setNotPrimaryKeyColumnJavaNames(notPrimaryKeyColumnJavaList.toArray(new String[0]));
        classMap.setPrimaryKeyColumnJavaNames(primaryKeyColumnJavaNamesList.toArray(new String[0]));
        classMap.setPrimaryKeyAndVersionColumnJavaNames(primaryKeyAndVersionColumnJavaNamesList.toArray(new String[0]));
    }

    private List<Field> getAllInheritedFields(Class<?> type) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class<?> c = type; c != null; c = c.getSuperclass()) {
            fields.addAll(Arrays.asList(c.getDeclaredFields()));
        }
        return fields;
    }
}

