/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.orm.mapper.clazz;

import com.jpattern.orm.annotation.Version;
import com.jpattern.orm.annotation.table.TableInfo;
import com.jpattern.orm.exception.OrmConfigurationException;
import com.jpattern.orm.exception.OrmException;
import com.jpattern.orm.mapper.clazz.IClassField;
import com.jpattern.orm.mapper.clazz.IClassMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ClassMap<BEAN>
implements IClassMap<BEAN> {
    private final TableInfo tableInfo;
    private final Class<BEAN> mappedClass;
    private final Map<String, IClassField<BEAN, ?>> fieldClassMapByJavaName = new HashMap();
    private final Map<String, IClassField<BEAN, ?>> fieldClassMapByDBColumnName = new HashMap();
    private String[] allColumnJavaNames = new String[0];
    private String[] allNotGeneratedColumnJavaNames = new String[0];
    private String[] primaryKeyColumnJavaNames = new String[0];
    private String[] primaryKeyAndVersionColumnJavaNames = new String[0];
    private String[] notPrimaryKeyColumnJavaNames = new String[0];
    private String[] allGeneratedColumnJavaNames = new String[0];
    private String[] allGeneratedColumnDBNames = new String[0];
    private boolean versionGenerator = false;

    public ClassMap(Class<BEAN> mappedClass, TableInfo tableInfo) {
        this.mappedClass = mappedClass;
        this.tableInfo = tableInfo;
    }

    @Override
    public Class<BEAN> getMappedClass() {
        return this.mappedClass;
    }

    @Override
    public <P> IClassField<BEAN, P> getClassFieldByJavaName(String javaName) {
        if (this.fieldClassMapByJavaName.containsKey(javaName)) {
            return this.fieldClassMapByJavaName.get(javaName);
        }
        throw new OrmException("Property with name [" + javaName + "] not found in class " + this.mappedClass);
    }

    @Override
    public <P> IClassField<BEAN, P> getClassFieldByDBColumnName(String dbColumnName) {
        if (this.fieldClassMapByDBColumnName.containsKey(dbColumnName)) {
            return this.fieldClassMapByDBColumnName.get(dbColumnName);
        }
        throw new OrmException("DB Column with name [" + dbColumnName + "] not mapped for class " + this.mappedClass);
    }

    public <P> void addClassField(IClassField<BEAN, P> classField) {
        this.fieldClassMapByJavaName.put(classField.getFieldName(), classField);
        this.fieldClassMapByDBColumnName.put(classField.getColumnInfo().getDBColumnName(), classField);
        if (classField.getVersionInfo().isVersionable()) {
            if (this.versionGenerator) {
                throw new OrmConfigurationException("A bean can have maximum one field annotated with @" + Version.class.getSimpleName() + ". Error in class:[" + this.getMappedClass() + "] field: [" + classField.getFieldName() + "]");
            }
            this.versionGenerator = true;
        }
    }

    public Map<String, IClassField<BEAN, ?>> getUnmodifiableFieldClassMap() {
        return Collections.unmodifiableMap(this.fieldClassMapByJavaName);
    }

    @Override
    public String[] getAllColumnJavaNames() {
        return this.allColumnJavaNames;
    }

    @Override
    public String[] getPrimaryKeyColumnJavaNames() {
        return this.primaryKeyColumnJavaNames;
    }

    @Override
    public String[] getNotPrimaryKeyColumnJavaNames() {
        return this.notPrimaryKeyColumnJavaNames;
    }

    public void setAllColumnJavaNames(String[] allColumnJavaNames) {
        this.allColumnJavaNames = allColumnJavaNames;
    }

    public void setPrimaryKeyColumnJavaNames(String[] primaryKeyColumnJavaNames) {
        this.primaryKeyColumnJavaNames = primaryKeyColumnJavaNames;
    }

    public void setNotPrimaryKeyColumnJavaNames(String[] notPrimaryKeyColumnJavaNames) {
        this.notPrimaryKeyColumnJavaNames = notPrimaryKeyColumnJavaNames;
    }

    public void setAllNotGeneratedColumnJavaNames(String[] allNotGeneratedColumnJavaNames) {
        this.allNotGeneratedColumnJavaNames = allNotGeneratedColumnJavaNames;
    }

    @Override
    public String[] getAllNotGeneratedColumnJavaNames() {
        return this.allNotGeneratedColumnJavaNames;
    }

    public void setAllGeneratedColumnJavaNames(String[] allGeneratedColumnJavaNames) {
        this.allGeneratedColumnJavaNames = allGeneratedColumnJavaNames;
    }

    @Override
    public String[] getAllGeneratedColumnJavaNames() {
        return this.allGeneratedColumnJavaNames;
    }

    public void setPrimaryKeyAndVersionColumnJavaNames(String[] primaryKeyAndVersionColumnJavaNames) {
        this.primaryKeyAndVersionColumnJavaNames = primaryKeyAndVersionColumnJavaNames;
    }

    @Override
    public String[] getPrimaryKeyAndVersionColumnJavaNames() {
        return this.primaryKeyAndVersionColumnJavaNames;
    }

    @Override
    public TableInfo getTableInfo() {
        return this.tableInfo;
    }

    @Override
    public String[] getAllGeneratedColumnDBNames() {
        return this.allGeneratedColumnDBNames;
    }

    public void setAllGeneratedColumnDBNames(String[] allGeneratedColumnDBNames) {
        this.allGeneratedColumnDBNames = allGeneratedColumnDBNames;
    }
}

