/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.orm.crud;

import com.jpattern.orm.crud.AColumnValueGenerator;
import com.jpattern.orm.crud.CRUDQuery;
import com.jpattern.orm.crud.ColumnValueGeneratorFactory;
import com.jpattern.orm.crud.OrmCRUDQuery;
import com.jpattern.orm.dialect.Dialect;
import com.jpattern.orm.mapper.clazz.ClassField;
import com.jpattern.orm.mapper.clazz.IClassField;
import com.jpattern.orm.mapper.clazz.IClassMap;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrmCRUDQueryGenerator<BEAN> {
    private boolean generatedKey = false;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Dialect dialect;
    private final IClassMap<BEAN> classMap;

    public OrmCRUDQueryGenerator(Dialect dialect, IClassMap<BEAN> classMap) {
        this.dialect = dialect;
        this.classMap = classMap;
    }

    public CRUDQuery generate() {
        OrmCRUDQuery crud = new OrmCRUDQuery();
        crud.setDeleteQuery(this.generateDeleteQuery());
        crud.setExistQuery(this.generateExistQuery());
        crud.setLoadQuery(this.generateLoadQuery());
        crud.setSaveQuery(this.generateSaveQuery(false));
        crud.setSaveQueryWithoutGenerators(this.generateSaveQuery(true));
        crud.setUpdateQuery(this.generateUpdateQuery());
        crud.setBaseSelectClause(this.generateBaseSelectClause());
        crud.setBaseFromClause(this.generateBaseFromClause());
        crud.setBeanVersionQuery(this.generateBeanVersionQuery());
        return crud;
    }

    private String generateBaseFromClause() {
        return this.classMap.getTableInfo().getTableNameWithSchema();
    }

    private String generateBaseSelectClause() {
        return this.columnToCommaSepareted("?", this.getColumnNames(this.classMap.getAllColumnJavaNames()), true);
    }

    private String generateUpdateQuery() {
        StringBuilder builder = new StringBuilder("UPDATE ");
        builder.append(this.classMap.getTableInfo().getTableNameWithSchema());
        builder.append(" SET ");
        if (this.classMap.getNotPrimaryKeyColumnJavaNames().length > 0) {
            builder.append(this.columnToSetClause(this.getColumnNames(this.classMap.getNotPrimaryKeyColumnJavaNames())));
        }
        if (this.classMap.getPrimaryKeyColumnJavaNames().length > 0) {
            builder.append(" WHERE ");
            builder.append(this.columnToWhereClause(this.getColumnNames(this.classMap.getPrimaryKeyColumnJavaNames())));
        }
        String query = builder.toString();
        this.logger.info("Generated UPDATE query for table [" + this.classMap.getTableInfo().getTableNameWithSchema() + "]:\n" + query);
        return query;
    }

    private String generateSaveQuery(boolean ignoreGenerators) {
        StringBuilder builder = new StringBuilder("INSERT INTO ");
        builder.append(this.classMap.getTableInfo().getTableNameWithSchema());
        builder.append(" (");
        builder.append(this.columnToCommaSepareted("", this.getColumnNames(this.classMap.getAllColumnJavaNames()), ignoreGenerators));
        builder.append(") VALUES (");
        builder.append(this.questionCommaSepareted(this.getColumnNames(this.classMap.getAllColumnJavaNames()), ignoreGenerators));
        builder.append(")");
        String query = builder.toString();
        this.logger.info("Generated INSERT query (with generators? " + !ignoreGenerators + ") for table [" + this.classMap.getTableInfo().getTableNameWithSchema() + "]:\n" + query);
        return query;
    }

    private String generateExistQuery() {
        String query = this.buildLoadQueryCommon("count(*)");
        this.logger.info("Generated EXIST query for table [" + this.classMap.getTableInfo().getTableNameWithSchema() + "]:\n" + query);
        return query;
    }

    private String generateLoadQuery() {
        String query = this.buildLoadQueryCommon("*");
        this.logger.info("Generated SELECT query for table [" + this.classMap.getTableInfo().getTableNameWithSchema() + "]:\n" + query);
        return query;
    }

    private String buildLoadQueryCommon(String selectClause) {
        StringBuilder builder = new StringBuilder("SELECT ");
        builder.append(selectClause);
        builder.append(" FROM ");
        builder.append(this.classMap.getTableInfo().getTableNameWithSchema());
        if (this.classMap.getPrimaryKeyColumnJavaNames().length > 0) {
            builder.append(" WHERE ");
            builder.append(this.columnToWhereClause(this.getColumnNames(this.classMap.getPrimaryKeyColumnJavaNames())));
        }
        return builder.toString();
    }

    private String generateBeanVersionQuery() {
        String query = "";
        for (String columnJavaName : this.classMap.getAllColumnJavaNames()) {
            IClassField classField = this.classMap.getClassFieldByJavaName(columnJavaName);
            if (!classField.getVersionInfo().isVersionable()) continue;
            StringBuilder builder = new StringBuilder("SELECT count(*) FROM ");
            builder.append(this.classMap.getTableInfo().getTableNameWithSchema());
            builder.append(" WHERE ");
            builder.append(this.columnToWhereClause(this.getColumnNames(this.classMap.getPrimaryKeyAndVersionColumnJavaNames())));
            builder.append(this.classMap.getClassFieldByJavaName(classField.getFieldName()).getVersionInfo().getLockMode().getMode());
            query = builder.toString();
        }
        this.logger.info("Generated query to load the version of a record for table [" + this.classMap.getTableInfo().getTableNameWithSchema() + "]:\n" + query);
        return query;
    }

    private String generateDeleteQuery() {
        StringBuilder builder = new StringBuilder("DELETE FROM ");
        builder.append(this.classMap.getTableInfo().getTableNameWithSchema());
        if (this.classMap.getPrimaryKeyColumnJavaNames().length > 0) {
            builder.append(" WHERE ");
            builder.append(this.columnToWhereClause(this.getColumnNames(this.classMap.getPrimaryKeyColumnJavaNames())));
        }
        String query = builder.toString();
        this.logger.info("Generated DELETE query for table [" + this.classMap.getTableInfo().getTableNameWithSchema() + "]:\n" + query);
        return query;
    }

    private String questionCommaSepareted(List<String> columnNames, boolean ignoreGenerators) {
        StringBuilder builder = new StringBuilder();
        int length = columnNames.size();
        if (length > 0) {
            for (int i = 0; i < length - 1; ++i) {
                AColumnValueGenerator columnValueGenerator = this.getColumnValueGenerator(columnNames.get(i), ignoreGenerators);
                this.generatedKey = this.generatedKey || columnValueGenerator.isAutoGenerated();
                String queryParameter = columnValueGenerator.insertQueryParameter(this.dialect, "?");
                if (queryParameter.length() <= 0) continue;
                builder.append(queryParameter);
                builder.append(", ");
            }
            AColumnValueGenerator columnValueGenerator = this.getColumnValueGenerator(columnNames.get(length - 1), ignoreGenerators);
            this.generatedKey = this.generatedKey || columnValueGenerator.isAutoGenerated();
            builder.append(columnValueGenerator.insertQueryParameter(this.dialect, "?"));
        }
        return builder.toString();
    }

    private String columnToCommaSepareted(String prefix, List<String> columnNames, boolean ignoreGenerators) {
        StringBuilder builder = new StringBuilder();
        int length = columnNames.size();
        if (length > 0) {
            for (int i = 0; i < length - 1; ++i) {
                AColumnValueGenerator columnValueGenerator = this.getColumnValueGenerator(columnNames.get(i), ignoreGenerators);
                String queryParameter = columnValueGenerator.insertColumn(this.dialect, prefix + columnNames.get(i));
                if (queryParameter.length() <= 0) continue;
                builder.append(queryParameter);
                builder.append(", ");
            }
            AColumnValueGenerator columnValueGenerator = this.getColumnValueGenerator(columnNames.get(length - 1), ignoreGenerators);
            builder.append(columnValueGenerator.insertColumn(this.dialect, prefix + columnNames.get(length - 1)));
        }
        return builder.toString();
    }

    private AColumnValueGenerator getColumnValueGenerator(String columnName, boolean ignoreGenerator) {
        return ColumnValueGeneratorFactory.getColumnValueGenerator((ClassField)this.classMap.getClassFieldByDBColumnName(columnName), ignoreGenerator);
    }

    private String columnToWhereClause(List<String> columnNames) {
        StringBuilder builder = new StringBuilder();
        int length = columnNames.size();
        if (length > 0) {
            for (int i = 0; i < length - 1; ++i) {
                builder.append(columnNames.get(i) + " = ? AND ");
            }
            builder.append(columnNames.get(length - 1) + " = ? ");
        }
        return builder.toString();
    }

    private String columnToSetClause(List<String> columnNames) {
        StringBuilder builder = new StringBuilder();
        int length = columnNames.size();
        if (length > 0) {
            for (int i = 0; i < length - 1; ++i) {
                builder.append(columnNames.get(i) + " = ? , ");
            }
            builder.append(columnNames.get(length - 1) + " = ? ");
        }
        return builder.toString();
    }

    private List<String> getColumnNames(String[] javaNames) {
        ArrayList<String> result = new ArrayList<String>();
        for (String javaName : javaNames) {
            result.add(this.classMap.getClassFieldByJavaName(javaName).getColumnInfo().getDBColumnName());
        }
        return result;
    }
}

