/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.orm.crud;

import com.jpattern.orm.annotation.generator.GeneratorType;
import com.jpattern.orm.crud.AColumnValueGenerator;
import com.jpattern.orm.crud.AutogeneratedColumnValueGenerator;
import com.jpattern.orm.crud.NullColumnValueGenerator;
import com.jpattern.orm.crud.SequenceColumnValueGenerator;
import com.jpattern.orm.mapper.clazz.ClassField;

public class ColumnValueGeneratorFactory {
    private ColumnValueGeneratorFactory() {
    }

    public static <BEAN> AColumnValueGenerator getColumnValueGenerator(ClassField<BEAN, ? extends Object> classField, boolean ignoreGenerator) {
        AColumnValueGenerator columnValueGenerator = new NullColumnValueGenerator(classField.getGeneratorInfo().getName());
        if (!ignoreGenerator) {
            if (classField.getGeneratorInfo().getGeneratorType().equals((Object)GeneratorType.SEQUENCE)) {
                columnValueGenerator = new SequenceColumnValueGenerator(classField.getGeneratorInfo().getName());
            }
            if (classField.getGeneratorInfo().getGeneratorType().equals((Object)GeneratorType.AUTOGENERATED)) {
                columnValueGenerator = new AutogeneratedColumnValueGenerator(classField.getGeneratorInfo().getName());
            }
        }
        columnValueGenerator.setActivateValues(classField.getGeneratorInfo().getIfValueIn());
        columnValueGenerator.setGeneratedColumnName(classField.getColumnInfo().getDBColumnName());
        return columnValueGenerator;
    }
}

