/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.orm;

import com.jpattern.orm.JPO;
import com.jpattern.orm.crud.CRUDQuery;
import com.jpattern.orm.crud.OrmCRUDQueryGenerator;
import com.jpattern.orm.dialect.Dialect;
import com.jpattern.orm.exception.OrmConfigurationException;
import com.jpattern.orm.mapper.IOrmClassToolMap;
import com.jpattern.orm.mapper.NullOrmClassToolMap;
import com.jpattern.orm.mapper.OrmClassTool;
import com.jpattern.orm.mapper.OrmClassToolMap;
import com.jpattern.orm.mapper.clazz.ClassMapBuilder;
import com.jpattern.orm.mapper.clazz.IClassMap;
import com.jpattern.orm.persistor.IOrmPersistor;
import com.jpattern.orm.persistor.ReflectionPersistorGenerator;
import com.jpattern.orm.persistor.type.ExtendedTypeWrapper;
import com.jpattern.orm.persistor.type.TypeFactory;
import com.jpattern.orm.session.NullSessionProvider;
import com.jpattern.orm.session.OrmSession;
import com.jpattern.orm.session.Session;
import com.jpattern.orm.session.SessionProvider;
import com.jpattern.orm.validator.NullValidator;
import com.jpattern.orm.validator.Validator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPOrm
implements JPO {
    private static Integer JPORM_INSTANCES_COUNT = 0;
    private SessionProvider sessionProvider;
    private IOrmClassToolMap ormClassToolMap = new OrmClassToolMap(this);
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Dialect dialect;
    private final Integer instanceCount;
    private final TypeFactory typeFactory = new TypeFactory();
    private Validator validator = new NullValidator();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JPOrm(SessionProvider sessionProvider) {
        Integer n = JPORM_INSTANCES_COUNT;
        synchronized (n) {
            Integer n2 = JPORM_INSTANCES_COUNT;
            Integer n3 = JPORM_INSTANCES_COUNT = Integer.valueOf(JPORM_INSTANCES_COUNT + 1);
            this.instanceCount = n2;
        }
        this.logger.info("Building new instance of JPO (instance [{}])", (Object)this.instanceCount);
        this.sessionProvider = sessionProvider;
        this.dialect = sessionProvider.getDBType().getDialect();
    }

    @Override
    public final Session session() {
        return new OrmSession(this.ormClassToolMap, this.sessionProvider.getSessionStrategy(), this.typeFactory, this.validator);
    }

    public synchronized <BEAN> void register(Class<BEAN> clazz) throws OrmConfigurationException {
        try {
            if (!this.ormClassToolMap.containsTool(clazz)) {
                this.logger.info("register new class: " + clazz.getName());
                IClassMap<BEAN> classMap = new ClassMapBuilder<BEAN>(clazz).generate();
                IOrmPersistor<BEAN> ormPersistor = new ReflectionPersistorGenerator<BEAN>(classMap, this.typeFactory).generate();
                CRUDQuery ormCRUDQuery = new OrmCRUDQueryGenerator<BEAN>(this.dialect, classMap).generate();
                OrmClassTool<BEAN> ormClassTool = new OrmClassTool<BEAN>(classMap, ormPersistor, ormCRUDQuery);
                this.ormClassToolMap.put(clazz, ormClassTool);
            }
        }
        catch (Exception e) {
            throw new OrmConfigurationException(e);
        }
    }

    @Override
    public synchronized void destory() {
        this.sessionProvider = new NullSessionProvider();
        this.ormClassToolMap = new NullOrmClassToolMap();
    }

    @Override
    public synchronized void register(List<Class<?>> classes) throws OrmConfigurationException {
        for (Class<?> clazz : classes) {
            this.register((Class)clazz);
        }
    }

    public SessionProvider getSessionProvider() {
        return this.sessionProvider;
    }

    @Override
    public synchronized void register(ExtendedTypeWrapper<?, ?> typeWrapper) throws OrmConfigurationException {
        this.typeFactory.addTypeWrapper(typeWrapper);
    }

    @Override
    public synchronized void setValidator(Validator validator) {
        if (validator != null) {
            this.validator = validator;
        }
    }

    public TypeFactory getTypeFactory() {
        return this.typeFactory;
    }
}

