package com.jpattern.orm.validator;

import java.util.List;

import net.sf.oval.ConstraintViolation;
import net.sf.oval.configuration.annotation.AnnotationsConfigurer;
import net.sf.oval.configuration.annotation.BeanValidationAnnotationsConfigurer;

/**
 * A {@link Validator} that uses Oval validator framework
 * @author ufo
 *
 */
public class OvalValidator implements Validator {

	public OvalValidator() {
	}

	@Override
	public void validate(final Object bean) throws OrmOvalValidatorException {
		net.sf.oval.Validator validator = new net.sf.oval.Validator(new AnnotationsConfigurer(), new BeanValidationAnnotationsConfigurer());
		List<ConstraintViolation> result = validator.validate(bean);
		if (!result.isEmpty()) {
			throw new OrmOvalValidatorException("Error validating the bean", result);
		}
	}

}
