package com.jpattern.orm.validator;

import java.util.Collections;
import java.util.List;

import net.sf.oval.ConstraintViolation;

import com.jpattern.orm.exception.validator.OrmValidatorException;

/**
 * 
 * @author ufo
 *
 */
public class OrmOvalValidatorException extends OrmValidatorException {

	private static final long serialVersionUID = 1L;
	private final List<ConstraintViolation> constraintViolations;

	public OrmOvalValidatorException(final String message, final List<ConstraintViolation> constraintViolations) {
		super(message);
		this.constraintViolations = Collections.unmodifiableList(constraintViolations);
	}

	public List<ConstraintViolation> getConstraintViolations() {
		return this.constraintViolations;
	}

}
