package com.jpattern.orm.validator;

import java.util.Collections;
import java.util.Set;

import javax.validation.ConstraintViolation;

import com.jpattern.orm.exception.validator.OrmValidatorException;

/**
 * 
 * @author ufo
 *
 */
public class OrmJSR303ValidatorException extends OrmValidatorException {

	private static final long serialVersionUID = 1L;
	private final Set<ConstraintViolation<Object>> constraintViolations;

	public OrmJSR303ValidatorException(final String message, final Set<ConstraintViolation<Object>> constraintViolations) {
		super(message);
		this.constraintViolations = Collections.unmodifiableSet(constraintViolations);
	}

	public Set<ConstraintViolation<Object>> getConstraintViolations() {
		return this.constraintViolations;
	}

}
