package com.jpattern.orm.validator;

import java.util.Set;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidatorFactory;

/**
 * A validator for the JSR303
 * @author ufo
 *
 */
public class JSR303Validator implements Validator {

	private ValidatorFactory factory;

	public JSR303Validator() {
		this.factory = Validation.buildDefaultValidatorFactory();
	}

	@Override
	public void validate(final Object bean) {
		Set<ConstraintViolation<Object>> result = this.factory.getValidator().validate(bean);
		if (!result.isEmpty()) {
			throw new OrmJSR303ValidatorException("Error validating the bean", result);
		}

	}

}
