package com.jpattern.orm.transaction;

/**
 * 
 * @author Francesco Cina
 *
 * 13/giu/2011
 */
public enum TransactionPropagation {
	
	/**
	 * Support a current transaction; create a new one if none exists.
	 * This is the default setting.
	 */
	REQUIRED(0),
	
	/**
	 * Support a current transaction; execute non-transactionally if none exists.
	 * Note that the exact behavior depends on the actual orm backend.
	 */
	SUPPORTS(1),
	
	/**
	 * Support a current transaction; throw an exception if no current transaction
	 * exists.
	 */
	MANDATORY(2), 
	
	/**
	 * Create a new transaction, suspending the current transaction if one exists.
	 * Note that the exact behavior depends on the actual orm backend.
	 */
	REQUIRES_NEW(3),
	
	/**
	 * Do not support a current transaction; rather always execute non-transactionally.
	 */
	NOT_SUPPORTED(4),
	
	/**
	 * Do not support a current transaction; throw an exception if a current transaction
	 * exists.
	 */
	NEVER(5),
	
	/**
	 * Execute within a nested transaction if a current transaction exists.
	 * Note that the exact behavior depends on the actual orm backend.
	 */
	NESTED(6);

	 private int propagation;

	 private TransactionPropagation(int propagation) {
		 this.propagation = propagation;
	 }

	 public int getTransactionPropagation() {
	   return propagation;
	 }
}
