package com.jpattern.orm.transaction;

import java.io.Serializable;

/**
 * 
 * @author cinafr
 *
 */
public interface TransactionDefinition extends Serializable {

	/**
	 * Use the default timeout of the underlying transaction system,
	 * or none if timeouts are not supported. 
	 */
	int TIMEOUT_DEFAULT = -1;
	
	TransactionPropagation PROPAGATION_DEFAULT = TransactionPropagation.REQUIRED;
	
	TransactionIsolation ISOLATION_DEFAULT = TransactionIsolation.DEFAULT;
	
	boolean READ_ONLY_DEFAULT = false;


	/**
	 * Return the propagation behavior.
	 */
	TransactionPropagation getPropagation();

	/**
	 * Return the isolation level.
	 */
	TransactionIsolation getIsolationLevel();

	/**
	 * Return the transaction timeout.
	 */
	int getTimeout();

	/**
	 * Return whether to optimize as a read-only transaction.
	 */
	boolean isReadOnly();

}

