package com.jpattern.orm.session.reader;

import java.sql.ResultSet;
import java.sql.SQLException;

import com.jpattern.orm.exception.OrmNotUniqueResultManyResultsException;
import com.jpattern.orm.exception.OrmNotUniqueResultNoResultException;
import com.jpattern.orm.session.ResultSetReader;
import com.jpattern.orm.session.ResultSetRowReader;

/**
 * 
 * @author ufo
 *
 */
public class ResultSetRowReaderToResultSetReaderUnique<T> implements ResultSetReader<T> {

	private final ResultSetRowReader<T> rsrr;
	public ResultSetRowReaderToResultSetReaderUnique(final ResultSetRowReader<T> rsrr) {
		this.rsrr = rsrr;

	}
	@Override
	public T read(final ResultSet resultSet) throws SQLException {
		if ( resultSet.next() ) {
			T result = this.rsrr.readRow(resultSet, 0);
			if (resultSet.next()) {
				throw new OrmNotUniqueResultManyResultsException("The query execution returned a number of rows higher than 1");
			}
			return result;
		}
		throw new OrmNotUniqueResultNoResultException("The query execution has returned zero rows. One row was expected");
	}

}
