package com.jpattern.orm.session.reader;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import com.jpattern.orm.session.ResultSetReader;
import com.jpattern.orm.session.ResultSetRowReader;

/**
 * 
 * @author ufo
 *
 */
public class ResultSetRowReaderToResultSetReader<T> implements ResultSetReader<List<T>> {

	private final ResultSetRowReader<T> rsrr;
	public ResultSetRowReaderToResultSetReader(final ResultSetRowReader<T> rsrr) {
		this.rsrr = rsrr;

	}
	@Override
	public List<T> read(final ResultSet resultSet) throws SQLException {
		final List<T> results = new ArrayList<T>();
		int rowNum = 0;
		while ( resultSet.next() ) {
			results.add(this.rsrr.readRow(resultSet, rowNum++));
		}
		return results;
	}

}
