package com.jpattern.orm.session.reader;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import com.jpattern.orm.session.ResultSetReader;

/**
 * 
 * @author ufo
 *
 */
public class ListResultSetReader implements ResultSetReader<List<Object[]>> {

	@Override
	public List<Object[]> read(final ResultSet resultSet) throws SQLException {
		int columnNumber = resultSet.getMetaData().getColumnCount();
		List<Object[]> resultList = new ArrayList<Object[]>();
		while ( resultSet.next() ) {
			Object[] objectArray = new Object[columnNumber];
			for (int i=0 ; i<columnNumber ; i++) {
				objectArray[i] = resultSet.getObject(i+1);
			}
			resultList.add(objectArray);
		}
		return resultList;
	}

}
