package com.jpattern.orm.session.reader;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;

import com.jpattern.orm.exception.OrmNotUniqueResultManyResultsException;
import com.jpattern.orm.exception.OrmNotUniqueResultNoResultException;
import com.jpattern.orm.session.ResultSetReader;

/**
 * 
 * @author ufo
 *
 */
public class BigDecimalResultSetReader implements ResultSetReader<BigDecimal> {

	@Override
	public BigDecimal read(final ResultSet resultSet) throws SQLException {
		if ( resultSet.next() ) {
			BigDecimal result = resultSet.getBigDecimal(1);
			if (resultSet.next()) {
				throw new OrmNotUniqueResultManyResultsException("The query execution returned a number of rows higher than 1");
			}
			return result;
		}
		throw new OrmNotUniqueResultNoResultException("The query execution has returned zero rows. One row was expected");
	}

}
