package com.jpattern.orm.session.datasource;

import java.sql.SQLException;
import java.sql.Statement;

/**
 * 
 * @author ufo
 *
 */
public class StatementWrapper implements IStatement {

	private final Statement statement;
	private final IConnection conn;

	StatementWrapper(Statement statement, IConnection conn) {
		this.statement = statement;
		this.conn = conn;
	}

	@Override
	public void setQueryTimeout(int queryTimeout) throws SQLException {
		statement.setQueryTimeout(queryTimeout);		
	}

	@Override
	public void addBatch(String sql) throws SQLException {
		statement.addBatch(sql);		
	}

	@Override
	public int[] executeBatch() throws SQLException {
		conn.setReadOnly(false);
		return statement.executeBatch();
	}

	@Override
	public void close() throws SQLException {
		statement.close();		
	}
	
}
