package com.jpattern.orm.session.datasource;

import java.sql.PreparedStatement;

import com.jpattern.orm.exception.OrmException;

public interface IConnection {

	boolean isValid() throws OrmException;

	void setTransactionIsolation(int transactionIsolation) throws OrmException;

	boolean isClosed() throws OrmException;

	void rollback() throws OrmException;

	void commit() throws OrmException;

	PreparedStatement prepareStatement(String sql) throws OrmException;

	PreparedStatement prepareStatement(String sql, String[] generatedColumnNames) throws OrmException;

	IStatement createStatement() throws OrmException;

	void addCaller(IConnectionCaller connectionCaller) throws OrmException;

	void close(IConnectionCaller connectionCaller) throws OrmException;

	void setRollbackOnly() throws OrmException;

	void setReadOnly(boolean readOnly) throws OrmException;

}
