package com.jpattern.orm.session.datasource;

import com.jpattern.orm.exception.OrmException;
import com.jpattern.orm.session.SessionStrategy;
import com.jpattern.orm.session.SqlPerformerStrategy;
import com.jpattern.orm.transaction.Transaction;
import com.jpattern.orm.transaction.TransactionDefinition;

/**
 * 
 * @author Francesco Cina
 *
 * 21/mag/2011
 */
public class DataSourceSessionStrategy implements SessionStrategy {

	private final DataSourceSessionProvider dataSourceSessionProvider;

	public DataSourceSessionStrategy(DataSourceSessionProvider dataSourceSessionProvider) {
		this.dataSourceSessionProvider = dataSourceSessionProvider;
	}

	@Override
	public Transaction getTransaction(TransactionDefinition transactionDefinition) throws OrmException {
		return new DataSourceTransaction(dataSourceSessionProvider, transactionDefinition);
	}
	
	@Override
	public SqlPerformerStrategy sqlPerformerStrategy() throws OrmException {
		return new DataSourceSqlPerformerStrategy( dataSourceSessionProvider);
	}

}
