package com.jpattern.orm.session.datasource;

import javax.sql.DataSource;

import com.jpattern.orm.session.SessionProvider;
import com.jpattern.orm.session.SessionStrategy;

/**
 * 
 * @author Francesco Cina
 *
 * 21/mag/2011
 */
public class DataSourceSessionProvider extends SessionProvider {

	private final ThreadLocal<DataSourceConnection> threadLocalConnection = new ThreadLocal<DataSourceConnection>();
	private final DataSource dataSource;

	public DataSourceSessionProvider(final DataSource dataSource) {
		this.dataSource = dataSource;
	}

	@Override
	public SessionStrategy getSessionStrategy() {
		return new DataSourceSessionStrategy(this);
	}

	final DataSourceConnection getConnection(final boolean readOnly, final IConnectionCaller connectionCaller) {
		if (this.getLogger().isDebugEnabled()) {
			this.getLogger().debug("new connection asked by " + connectionCaller );
		}
		DataSourceConnection conn = this.threadLocalConnection.get();
		if ((conn==null) || !conn.isValid()) {
			if (this.getLogger().isDebugEnabled()) {
				this.getLogger().debug("no valid connections found, a new one will be created");
			}
			conn = new DataSourceConnection(this.dataSource, readOnly);
			this.threadLocalConnection.set(conn);
		}
		conn.setReadOnly(readOnly);
		conn.addCaller(connectionCaller);
		return conn;
	}

	@Override
	public DataSource getDataSource() {
		return this.dataSource;
	}

}
