package com.jpattern.orm.session;

import java.util.List;

import com.jpattern.orm.exception.OrmException;

/**
 * 
 * @author Francesco Cina'
 *
 * Dec 20, 2011
 */
public interface SqlPerformerStrategy {

	void execute(String sql, int timeout) throws OrmException;

	<T> T query(String sql, int timeout, int maxRows, final PreparedStatementSetter pss, ResultSetReader<T> rse) throws OrmException ;

	int update(String sql, int timeout, final PreparedStatementSetter pss) throws OrmException;

	int update(String sql, int timeout, GeneratedKeyReader generatedKeyReader, final PreparedStatementSetter pss) throws OrmException;

	int[] batchUpdate(List<String> sqls, int timeout) throws OrmException;

	int[] batchUpdate(String sql, List<Object[]> args, int timeout) throws OrmException;

	int[] batchUpdate(String sql, BatchPreparedStatementSetter psc, int timeout) throws OrmException;

}
