package com.jpattern.orm.session;

import java.sql.ResultSet;
import java.sql.SQLException;

/**
 * 
 * @author ufo
 *
 * @param <T>
 */
public interface ResultSetRowReader<T> {

	/**
	 * This method should not call <code>next()</code> on
	 * the {@link ResultSet}; it is only supposed to map values of the current row.
	 * @param rs the ResultSet to map (pre-initialized for the current row)
	 * @param rowNum the number of the current row
	 * @return the result object for the current row
	 */
	T readRow(ResultSet rs, int rowNum) throws SQLException;

}
