package com.jpattern.orm.session;

import java.util.List;

import com.jpattern.orm.exception.OrmException;

/**
 * 
 * @author Francesco Cina'
 *
 * Dec 20, 2011
 */
public class NullSqlPerformerStrategy implements SqlPerformerStrategy {

	@Override
	public void execute(final String sql, final int timeout) throws OrmException {
	}

	@Override
	public <T> T query(final String sql, final int timeout, final int maxRows, final PreparedStatementSetter pss, final ResultSetReader<T> rse) 	throws OrmException {
		return null;
	}

	@Override
	public int update(final String sql, final int timeout, final PreparedStatementSetter psc) throws OrmException {
		return 0;
	}

	@Override
	public int update(final String sql, final int timeout, final GeneratedKeyReader generatedKeyReader, final PreparedStatementSetter psc) throws OrmException {
		return 0;
	}

	@Override
	public int[] batchUpdate(final List<String> sqls, final int timeout) throws OrmException {
		return new int[0];
	}

	@Override
	public int[] batchUpdate(final String sql, final List<Object[]> args, final int timeout) throws OrmException {
		return new int[0];
	}

	@Override
	public int[] batchUpdate(final String sql, final BatchPreparedStatementSetter psc, final int timeout) throws OrmException {
		return new int[0];
	}

}
