package com.jpattern.orm.session;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import com.jpattern.orm.exception.OrmException;
import com.jpattern.orm.exception.OrmNotUniqueResultException;

/**
 * 
 * @author Francesco Cina
 *
 * 02/lug/2011
 */
public class NullSqlExecutor implements SqlPerformer {

	/**
	 * 
	 */


	@Override
	public void setMaxRows(final int maxRows) {
	}

	@Override
	public int getMaxRows() {
		return 0;
	}

	@Override
	public void setQueryTimeout(final int queryTimeout) {
	}

	@Override
	public int getQueryTimeout() {
		return 0;
	}

	@Override
	public void execute(final String sql) throws OrmException {
	}

	@Override
	public <T> T query(final String sql, final ResultSetReader<T> rse, final Object... args) throws OrmException {
		return null;
	}

	@Override
	public int update(final String sql, final Object... args) throws OrmException {
		return 0;
	}

	@Override
	public int update(final String sql, final GeneratedKeyReader generatedKeyExtractor, final Object... args) throws OrmException {
		return 0;
	}

	@Override
	public int[] batchUpdate(final List<String> sqls) throws OrmException {
		return new int[0];
	}

	@Override
	public int[] batchUpdate(final String sql, final List<Object[]> args) throws OrmException {
		return new int[0];
	}

	@Override
	public int[] batchUpdate(final String sql, final BatchPreparedStatementSetter psc) throws OrmException {
		return new int[0];
	}

	@Override
	public Integer queryForInt(final String sql, final Object... args) throws OrmException {
		return 0;
	}

	@Override
	public Long queryForLong(final String sql, final Object... args) throws OrmException {
		return 0l;
	}

	@Override
	public Double queryForDouble(final String sql, final Object... args) throws OrmException {
		return 0d;
	}

	@Override
	public Float queryForFloat(final String sql, final Object... args) throws OrmException {
		return 0f;
	}

	@Override
	public String queryForString(final String sql, final Object... args) throws OrmException {
		return "";
	}

	@Override
	public Boolean queryForBoolean(final String sql, final Object... args) throws OrmException {
		return Boolean.FALSE;
	}

	@Override
	public BigDecimal queryForBigDecimal(final String sql, final Object... args) throws OrmException {
		return new BigDecimal(0);
	}

	@Override
	public Object[] queryForArray(final String sql, final Object... args) throws OrmException {
		return new Object[0];
	}

	@Override
	public List<Object[]> queryForList(final String sql, final Object... args) throws OrmException {
		return new ArrayList<Object[]>();
	}

	@Override
	public int update(final String sql, final PreparedStatementSetter psc)
			throws OrmException {
		return 0;
	}

	@Override
	public int update(final String sql, final GeneratedKeyReader generatedKeyReader,
			final PreparedStatementSetter psc) throws OrmException {
		return 0;
	}

	@Override
	public <T> T query(final String sql, final ResultSetReader<T> rse, final Collection<?> args)
			throws OrmException {
		return null;
	}

	@Override
	public Integer queryForInt(final String sql, final Collection<?> args)
			throws OrmException, OrmNotUniqueResultException {
		return 0;
	}

	@Override
	public Long queryForLong(final String sql, final Collection<?> args)
			throws OrmException, OrmNotUniqueResultException {
		return 0l;
	}

	@Override
	public Double queryForDouble(final String sql, final Collection<?> args)
			throws OrmException, OrmNotUniqueResultException {
		return 0d;
	}

	@Override
	public Float queryForFloat(final String sql, final Collection<?> args)
			throws OrmException, OrmNotUniqueResultException {
		return 0f;
	}

	@Override
	public String queryForString(final String sql, final Collection<?> args)
			throws OrmException, OrmNotUniqueResultException {
		return "";
	}

	@Override
	public Boolean queryForBoolean(final String sql, final Collection<?> args)
			throws OrmException, OrmNotUniqueResultException {
		return Boolean.FALSE;
	}

	@Override
	public BigDecimal queryForBigDecimal(final String sql, final Collection<?> args)
			throws OrmException, OrmNotUniqueResultException {
		return new BigDecimal(0);
	}

	@Override
	public Object[] queryForArray(final String sql, final Collection<?> args)
			throws OrmException, OrmNotUniqueResultException {
		return new Object[0];
	}

	@Override
	public List<Object[]> queryForList(final String sql, final Collection<?> args)
			throws OrmException {
		return new ArrayList<Object[]>();
	}

	@Override
	public int update(final String sql, final Collection<?> args) throws OrmException {
		return 0;
	}

	@Override
	public int update(final String sql, final GeneratedKeyReader generatedKeyReader,
			final Collection<?> args) throws OrmException {
		return 0;
	}

	@Override
	public <T> List<T> query(final String sql, final ResultSetRowReader<T> rsrr,
			final Object... args) throws OrmException {
		return null;
	}

	@Override
	public <T> List<T> query(final String sql, final ResultSetRowReader<T> rsrr,
			final Collection<?> args) throws OrmException {
		return null;
	}

	@Override
	public <T> T queryForUnique(final String sql, final ResultSetRowReader<T> rsrr,
			final Object... args) throws OrmException, OrmNotUniqueResultException {
		return null;
	}

	@Override
	public <T> T queryForUnique(final String sql, final ResultSetRowReader<T> rsrr,
			final Collection<?> args) throws OrmException {
		return null;
	}

}
