package com.jpattern.orm.session;

import com.jpattern.orm.exception.OrmException;
import com.jpattern.orm.transaction.Transaction;
import com.jpattern.orm.transaction.TransactionDefinition;
import com.jpattern.orm.transaction.NullTransaction;

/**
 * 
 * @author Francesco Cina'
 *
 * Dec 20, 2011
 */
public class NullSessionStrategy implements SessionStrategy {

	@Override
	public Transaction getTransaction(
			TransactionDefinition transactionDefinition) throws OrmException {
		return new NullTransaction();
	}

	@Override
	public SqlPerformerStrategy sqlPerformerStrategy() throws OrmException {
		return new NullSqlPerformerStrategy();
	}

}
