package com.jpattern.orm.session;

import java.sql.PreparedStatement;
import java.sql.SQLException;

/**
 * 
 * @author Francesco Cina
 *
 * 02/lug/2011
 * 
 * Set the values of a PreparedStatement to be executed in a batch update.
 */
public interface BatchPreparedStatementSetter  {

	/**
	 * 
	 * @param ps the prepared statement
	 * @param i the index of the batch (from 0 to batchSize-1)
	 * @throws SQLException
	 */
	void set(PreparedStatement ps, int i) throws SQLException;

	int getBatchSize();
}
