package com.jpattern.orm.script;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.jpattern.orm.session.SessionSqlPerformer;
import com.jpattern.orm.session.SqlPerformer;

/**
 * 
 * @author Francesco Cina
 *
 * 02/lug/2011
 */
public class SessionParserCallback implements ParserCallback {

	private final SqlPerformer sqlExec;
	private final Logger logger = LoggerFactory.getLogger(this.getClass());

	public SessionParserCallback(final SessionSqlPerformer session) {
		this.sqlExec = session.sqlPerformer();
	}

	@Override
	public void parseAction(final String sqlStatement) {
		if (this.logger.isDebugEnabled()) {
			this.logger.debug("Execute statement: " + sqlStatement);
		}
		this.sqlExec.update(sqlStatement);
	}

}
