package com.jpattern.orm.script;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.jpattern.orm.exception.OrmException;
import com.jpattern.orm.session.SessionSqlPerformer;

/**
 * 
 * @author Francesco Cina
 *
 * 02/lug/2011
 */
public class ScriptExecutorImpl implements ScriptExecutor {

	private final SessionSqlPerformer session;
	private final Logger logger = LoggerFactory.getLogger(this.getClass());

	public ScriptExecutorImpl(final SessionSqlPerformer session) {
		this.session = session;
	}

	@Override
	public void execute(final String script) throws OrmException {
		Charset charset = Charset.defaultCharset();
		InputStream is = new ByteArrayInputStream(script.getBytes(charset));
		try {
			this.execute(is, charset);
		} catch (IOException e) {
			throw new OrmException(e);
		}
	}

	@Override
	public void execute(final InputStream scriptStream) throws IOException, OrmException {
		this.execute(scriptStream, Charset.defaultCharset());
	}

	@Override
	public void execute(final InputStream scriptStream, final Charset charset) throws IOException, OrmException {
		this.logger.info("Begin script execution");
		Parser parser = new StreamParser(scriptStream, true, charset);
		SessionParserCallback spc = new SessionParserCallback(this.session);
		parser.parse(spc);
		this.logger.info("End script execution");
	}

}
