package com.jpattern.orm.query.update;

import java.util.List;

import com.jpattern.orm.query.clause.OrmWhere;

/**
 * 
 * @author ufo
 *
 */
public class UpdateWhereImpl extends OrmWhere<UpdateWhere> implements UpdateWhere {

	private final UpdateQuery updateQuery;

	public UpdateWhereImpl(final UpdateQuery updateQuery) {
		this.updateQuery = updateQuery;

	}

	@Override
	public UpdateQuery query() {
		return this.updateQuery;
	}

	@Override
	public UpdateSet set() {
		return this.updateQuery.set();
	}

	@Override
	protected UpdateWhere where() {
		return this;
	}

	@Override
	public int perform() {
		return this.updateQuery.perform();
	}

	@Override
	public final void appendValues(final List<Object> values) {
		this.updateQuery.appendValues(values);
	}

	@Override
	public String renderSql() {
		return this.updateQuery.renderSql();
	}

	@Override
	public void renderSql(final StringBuilder stringBuilder) {
		this.updateQuery.renderSql(stringBuilder);
	}

	@Override
	public UpdateQuery setQueryTimeout(final int queryTimeout) {
		return this.updateQuery.setQueryTimeout(queryTimeout);
	}

	@Override
	public int getQueryTimeout() {
		return this.updateQuery.getQueryTimeout();
	}

}
