package com.jpattern.orm.query.update;

import java.util.List;

import com.jpattern.orm.query.clause.OrmSet;

/**
 * 
 * @author ufo
 *
 */
public class UpdateSetImpl extends OrmSet<UpdateSet> implements UpdateSet {

	private final UpdateQuery query;

	public UpdateSetImpl(final UpdateQuery query) {
		this.query = query;
	}

	@Override
	public String renderSql() {
		return this.query.renderSql();
	}

	@Override
	public void renderSql(final StringBuilder stringBuilder) {
		this.query.renderSql(stringBuilder);
	}

	@Override
	public void appendValues(final List<Object> values) {
		this.query.appendValues(values);
	}

	@Override
	public final int perform() {
		return this.query.perform();
	}

	@Override
	public UpdateQuery query() {
		return this.query;
	}

	@Override
	protected UpdateSet set() {
		return this;
	}

	@Override
	public UpdateWhere where() {
		return this.query.where();
	}

	@Override
	public UpdateQuery setQueryTimeout(final int queryTimeout) {
		return this.query.setQueryTimeout(queryTimeout);
	}

	@Override
	public int getQueryTimeout() {
		return this.query.getQueryTimeout();
	}

}
