package com.jpattern.orm.query.update;

import java.util.List;

import com.jpattern.orm.mapper.IOrmClassToolMap;
import com.jpattern.orm.persistor.type.TypeFactory;
import com.jpattern.orm.persistor.type.ext.WrapperTypeList;
import com.jpattern.orm.query.NameSolver;
import com.jpattern.orm.query.NameSolverConsumer;
import com.jpattern.orm.query.SmartRenderableSqlQuery;
import com.jpattern.orm.session.SessionSqlPerformer;
import com.jpattern.orm.session.SqlPerformer;

/**
 * 
 * @author Francesco Cina
 *
 * 10/lug/2011
 */
public class UpdateQueryOrm extends SmartRenderableSqlQuery implements UpdateQuery, NameSolverConsumer {

	private final UpdateSetImpl set = new UpdateSetImpl(this);
	private final UpdateWhereImpl where = new UpdateWhereImpl(this);
	//	private INameSolver nameSolver = new NullNameSolver();
	private int queryTimeout = 0;
	private final Class<?> clazz;
	private final IOrmClassToolMap ormClassToolMap;
	private final SessionSqlPerformer session;
	private final TypeFactory typeFactory;

	public UpdateQueryOrm(final Class<?> clazz, final IOrmClassToolMap ormClassToolMap, final SessionSqlPerformer session, final TypeFactory typeFactory) {
		this.clazz = clazz;
		this.ormClassToolMap = ormClassToolMap;
		this.session = session;
		this.typeFactory = typeFactory;
	}

	@Override
	public UpdateWhere where() {
		return this.where;
	}

	@Override
	public int perform() {
		final List<Object> values = new WrapperTypeList(this.typeFactory);
		appendValues(values);
		final SqlPerformer sqlExec = this.session.sqlPerformer();
		sqlExec.setQueryTimeout(getQueryTimeout());
		return sqlExec.update(renderSql(), values);
	}

	@Override
	public final void appendValues(final List<Object> values) {
		this.set.appendElementValues(values);
		this.where.appendElementValues(values);
	}

	@Override
	public UpdateQuery setQueryTimeout(final int queryTimeout) {
		this.queryTimeout = queryTimeout;
		return this;
	}

	@Override
	public int getQueryTimeout() {
		return this.queryTimeout;
	}

	@Override
	public void setNameSolver(final NameSolver nameSolver) {
		//		this.nameSolver = nameSolver;
		this.where.setNameSolver(nameSolver);
		this.set.setNameSolver(nameSolver);
	}

	@Override
	public int getStatusVersion() {
		return this.set.getElementStatusVersion() + this.where.getElementStatusVersion();
	}

	@Override
	public final void doRender(final StringBuilder StringBuilder) {
		StringBuilder.append("UPDATE ");
		StringBuilder.append(this.ormClassToolMap.getOrmClassTool(this.clazz).getClassMap().getTableInfo().getTableNameWithSchema() );
		StringBuilder.append(" ");
		this.set.renderSqlElement(StringBuilder);
		this.where.renderSqlElement(StringBuilder);
	}

	@Override
	public UpdateSet set() {
		return this.set;
	}

}
