package com.jpattern.orm.query.update;

import com.jpattern.orm.query.QueryRoot;
import com.jpattern.orm.query.RenderableSqlQuery;

/**
 * 
 * @author Francesco Cina
 *
 * 10/lug/2011
 */
public interface UpdateQueryCommon extends QueryRoot, RenderableSqlQuery {

	/**
	 * Perform the update and return the number of affected rows.
	 * @return
	 */
	int perform();

	/**
	 * Set the query timeout for the query.
	 */
	UpdateQuery setQueryTimeout(int queryTimeout);

	/**
	 * Return the query timeout for the query.
	 */
	int getQueryTimeout();


}
