package com.jpattern.orm.query.sql;

import com.jpattern.orm.exception.OrmException;
import com.jpattern.orm.query.BaseFindQuery;
import com.jpattern.orm.query.CustomQuery;

/**
 * 
 * @author Francesco Cina
 *
 * 09/lug/2011
 */
public interface SqlFindQuery extends CustomQuery, BaseFindQuery {

	/**
	 * Return the max rows for this query.
	 * @return
	 */
	int getMaxRows() throws OrmException;

	/**
	 * Set the maximum number of rows to return in the query.
	 * @param maxRows
	 * @return
	 */
	SqlFindQuery setMaxRows(int maxRows) throws OrmException;

	/**
	 * Set the query timeout for the query.
	 */
	SqlFindQuery setQueryTimeout(int queryTimeout);

	/**
	 * Return the query timeout for the query.
	 */
	int getQueryTimeout();

}
