package com.jpattern.orm.query.sql;

import java.util.List;

import com.jpattern.orm.session.SessionSqlPerformer;
import com.jpattern.orm.session.SqlPerformer;

/**
 * 
 * @author Francesco Cina
 *
 * 09/lug/2011
 */
public class PlainSqlListBatchUpdateQuery implements SqlBatchUpdateQuery {

	/**
	 * 
	 */
	
	private int queryTimeout = 0;
	private final SessionSqlPerformer session;
	private final List<String> sqls;

	public PlainSqlListBatchUpdateQuery(SessionSqlPerformer session, List<String> sqls) {
		this.session = session;
		this.sqls = sqls;
	}

	@Override
	public void execute() {
		update();
	}

	@Override
	public void setQueryTimeout(int queryTimeout) {
		this.queryTimeout = queryTimeout;
	}

	@Override
	public int getQueryTimeout() {
		return queryTimeout ;
	}

	@Override
	public int[] update() {
		SqlPerformer sqlExec = session.sqlPerformer();
		sqlExec.setQueryTimeout(getQueryTimeout());
		return sqlExec.batchUpdate(sqls);
	}

}
