package com.jpattern.orm.query.sql;

import java.math.BigDecimal;
import java.util.List;

import com.jpattern.orm.exception.OrmException;
import com.jpattern.orm.exception.OrmNotUniqueResultException;
import com.jpattern.orm.session.ResultSetReader;
import com.jpattern.orm.session.ResultSetRowReader;
import com.jpattern.orm.session.SessionSqlPerformer;
import com.jpattern.orm.session.SqlPerformer;

/**
 * 
 * @author Francesco Cina
 *
 * 09/lug/2011
 */
public class PlainSqlFindQuery implements SqlFindQuery {

	private final SessionSqlPerformer session;
	private final String sql;
	private final Object[] args;
	private int queryTimeout = 0;
	private int maxRows = 0;

	public PlainSqlFindQuery(final SessionSqlPerformer session, final String sql, final Object[] args) {
		this.session = session;
		this.sql = sql;
		this.args = args;
	}


	@Override
	public final int getMaxRows() throws OrmException {
		return this.maxRows;
	}

	@Override
	public final SqlFindQuery setQueryTimeout(final int queryTimeout) {
		this.queryTimeout = queryTimeout;
		return this;
	}

	@Override
	public final int getQueryTimeout() {
		return this.queryTimeout;
	}

	@Override
	public final SqlFindQuery setMaxRows(final int maxRows) throws OrmException {
		this.maxRows = maxRows;
		return this;
	}

	@Override
	public <T> T find(final ResultSetReader<T> rse) throws OrmException {
		SqlPerformer sqlExec = this.session.sqlPerformer();
		sqlExec.setMaxRows(getMaxRows());
		sqlExec.setQueryTimeout(getQueryTimeout());
		return sqlExec.query(this.sql, rse , this.args);
	}

	@Override
	public <T> List<T> find(final ResultSetRowReader<T> rsrr) throws OrmException {
		SqlPerformer sqlExec = this.session.sqlPerformer();
		sqlExec.setMaxRows(getMaxRows());
		sqlExec.setQueryTimeout(getQueryTimeout());
		return sqlExec.query(this.sql, rsrr , this.args);
	}

	@Override
	public <T> T findUnique(final ResultSetRowReader<T> rsrr) throws OrmException {
		SqlPerformer sqlExec = this.session.sqlPerformer();
		sqlExec.setMaxRows(getMaxRows());
		sqlExec.setQueryTimeout(getQueryTimeout());
		return sqlExec.queryForUnique(this.sql, rsrr , this.args);
	}

	@Override
	public List<Object[]> findList() throws OrmException {
		SqlPerformer sqlExec = this.session.sqlPerformer();
		sqlExec.setMaxRows(getMaxRows());
		sqlExec.setQueryTimeout(getQueryTimeout());
		return sqlExec.queryForList(this.sql, this.args);
	}

	@Override
	public Object[] findUnique() throws OrmNotUniqueResultException {
		SqlPerformer sqlExec = this.session.sqlPerformer();
		sqlExec.setMaxRows(getMaxRows());
		sqlExec.setQueryTimeout(getQueryTimeout());
		return sqlExec.queryForArray(this.sql, this.args);
	}

	@Override
	public int findInt() throws OrmException {
		SqlPerformer sqlExec = this.session.sqlPerformer();
		sqlExec.setMaxRows(getMaxRows());
		sqlExec.setQueryTimeout(getQueryTimeout());
		return sqlExec.queryForInt(this.sql, this.args);
	}

	@Override
	public long findLong() throws OrmException {
		SqlPerformer sqlExec = this.session.sqlPerformer();
		sqlExec.setMaxRows(getMaxRows());
		sqlExec.setQueryTimeout(getQueryTimeout());
		return sqlExec.queryForLong(this.sql, this.args);
	}

	@Override
	public double findDouble() throws OrmException {
		SqlPerformer sqlExec = this.session.sqlPerformer();
		sqlExec.setMaxRows(getMaxRows());
		sqlExec.setQueryTimeout(getQueryTimeout());
		return sqlExec.queryForDouble(this.sql, this.args);
	}

	@Override
	public float findFloat() throws OrmException {
		SqlPerformer sqlExec = this.session.sqlPerformer();
		sqlExec.setMaxRows(getMaxRows());
		sqlExec.setQueryTimeout(getQueryTimeout());
		return sqlExec.queryForFloat(this.sql, this.args);
	}

	@Override
	public String findString() throws OrmException {
		SqlPerformer sqlExec = this.session.sqlPerformer();
		sqlExec.setMaxRows(getMaxRows());
		sqlExec.setQueryTimeout(getQueryTimeout());
		return sqlExec.queryForString(this.sql, this.args);
	}

	@Override
	public boolean findBoolean() throws OrmException {
		SqlPerformer sqlExec = this.session.sqlPerformer();
		sqlExec.setMaxRows(getMaxRows());
		sqlExec.setQueryTimeout(getQueryTimeout());
		return sqlExec.queryForBoolean(this.sql, this.args);
	}

	@Override
	public BigDecimal findBigDecimal() throws OrmException {
		SqlPerformer sqlExec = this.session.sqlPerformer();
		sqlExec.setMaxRows(getMaxRows());
		sqlExec.setQueryTimeout(getQueryTimeout());
		return sqlExec.queryForBigDecimal(this.sql, this.args);
	}


	@Override
	public String renderSql() {
		return this.sql;
	}


	@Override
	public void renderSql(final StringBuilder stringBuilder) {
		stringBuilder.append(this.sql);
	}


	@Override
	public void appendValues(final List<Object> values) {
		for (Object object : this.args) {
			values.add(object);
		}
	}

}
