package com.jpattern.orm.query.sql;

import java.util.List;

import com.jpattern.orm.exception.OrmException;
import com.jpattern.orm.session.GeneratedKeyReader;
import com.jpattern.orm.session.BatchPreparedStatementSetter;
import com.jpattern.orm.session.SessionSqlPerformer;

/**
 * 
 * @author Francesco Cina
 *
 * 09/lug/2011
 */
public class PlainSqlExecutor implements SqlExecutor {

	/**
	 * 
	 */
	
	private final SessionSqlPerformer session;

	public PlainSqlExecutor(SessionSqlPerformer session) {
		this.session = session;
	}

	@Override
	public SqlFindQuery findQuery(String sql, Object... args) {
		return new PlainSqlFindQuery(session, sql, args);
	}

	@Override
	public SqlExecuteQuery executeQuery(String sql) throws OrmException {
		return new PlainSqlExecuteQuery(session, sql);
	}

	@Override
	public SqlUpdateQuery updateQuery(String sql, Object... args) throws OrmException {
		return new PlainSqlUpdateQuery(session, sql, args);
	}

	@Override
	public SqlUpdateQuery updateQuery(String sql, GeneratedKeyReader generatedKeyReader, Object... args) throws OrmException {
		return new PlainGKReaderSqlUpdateQuery(session, sql, generatedKeyReader, args);
	}

	@Override
	public SqlBatchUpdateQuery batchUpdate(List<String> sqls) throws OrmException {
		return new PlainSqlListBatchUpdateQuery(session, sqls);
	}

	@Override
	public SqlBatchUpdateQuery batchUpdate(String sql, List<Object[]> args) throws OrmException {
		return new PlainSqlBatchUpdateQuery(session, sql, args);
	}

	@Override
	public SqlBatchUpdateQuery batchUpdate(String sql, BatchPreparedStatementSetter psc) throws OrmException {
		return new PlainPSCreatorSqlUpdate(session, sql, psc);
	}

}
