package com.jpattern.orm.query.sql;

import com.jpattern.orm.session.SessionSqlPerformer;
import com.jpattern.orm.session.SqlPerformer;

/**
 * 
 * @author Francesco Cina
 *
 * 09/lug/2011
 */
public class PlainSqlExecuteQuery implements SqlExecuteQuery {

	/**
	 * 
	 */
	
	private int queryTimeout = 0;
	private final SessionSqlPerformer session;
	private final String sql;

	public PlainSqlExecuteQuery(SessionSqlPerformer session, String sql) {
		this.session = session;
		this.sql = sql;
	}

	@Override
	public void execute() {
		SqlPerformer sqlExec = session.sqlPerformer();
		sqlExec.setQueryTimeout(getQueryTimeout());
		sqlExec.execute(sql);
	}

	@Override
	public void setQueryTimeout(int queryTimeout) {
		this.queryTimeout = queryTimeout;
	}

	@Override
	public int getQueryTimeout() {
		return queryTimeout;
	}

}
