package com.jpattern.orm.query.sql;

import java.util.List;

import com.jpattern.orm.session.SessionSqlPerformer;
import com.jpattern.orm.session.SqlPerformer;

/**
 * 
 * @author Francesco Cina
 *
 * 09/lug/2011
 */
public class PlainSqlBatchUpdateQuery implements SqlBatchUpdateQuery {

	/**
	 * 
	 */
	
	private int queryTimeout = 0;
	private final SessionSqlPerformer session;
	private final String sql;
	private final List<Object[]> args;

	public PlainSqlBatchUpdateQuery(SessionSqlPerformer session, String sql, List<Object[]> args) {
		this.session = session;
		this.sql = sql;
		this.args = args;
	}

	@Override
	public void execute() {
		update();
	}

	@Override
	public void setQueryTimeout(int queryTimeout) {
		this.queryTimeout  = queryTimeout;
	}

	@Override
	public int getQueryTimeout() {
		return queryTimeout;
	}

	@Override
	public int[] update() {
		SqlPerformer sqlExec = session.sqlPerformer();
		sqlExec.setQueryTimeout(getQueryTimeout());
		return sqlExec.batchUpdate(sql , args);
	}

}
