package com.jpattern.orm.query.sql;

import com.jpattern.orm.session.BatchPreparedStatementSetter;
import com.jpattern.orm.session.SessionSqlPerformer;
import com.jpattern.orm.session.SqlPerformer;

/**
 * 
 * @author Francesco Cina
 *
 * 09/lug/2011
 */
public class PlainPSCreatorSqlUpdate implements SqlBatchUpdateQuery {

	/**
	 * 
	 */
	
	private int queryTimeout = 0;
	private final SessionSqlPerformer session;
	private final String sql;
	private final BatchPreparedStatementSetter psc;

	public PlainPSCreatorSqlUpdate(SessionSqlPerformer session, String sql, BatchPreparedStatementSetter psc) {
		this.session = session;
		this.sql = sql;
		this.psc = psc;
	}

	@Override
	public void execute() {
		update();
	}

	@Override
	public void setQueryTimeout(int queryTimeout) {
		this.queryTimeout  = queryTimeout;
	}

	@Override
	public int getQueryTimeout() {
		return queryTimeout;
	}

	@Override
	public int[] update() {
		SqlPerformer sqlExec = session.sqlPerformer();
		sqlExec.setQueryTimeout(getQueryTimeout());
		return sqlExec.batchUpdate(sql , psc);
	}

}
