package com.jpattern.orm.query.sql;

import com.jpattern.orm.session.GeneratedKeyReader;
import com.jpattern.orm.session.SessionSqlPerformer;
import com.jpattern.orm.session.SqlPerformer;

/**
 * 
 * @author Francesco Cina
 *
 * 09/lug/2011
 */
public class PlainGKReaderSqlUpdateQuery implements SqlUpdateQuery {

	/**
	 * 
	 */
	
	private int queryTimeout = 0;
	private final SessionSqlPerformer session;
	private final String sql;
	private final GeneratedKeyReader generatedKeyReader;
	private final Object[] args;

	public PlainGKReaderSqlUpdateQuery(SessionSqlPerformer session, String sql, GeneratedKeyReader generatedKeyReader, Object[] args) {
		this.session = session;
		this.sql = sql;
		this.generatedKeyReader = generatedKeyReader;
		this.args = args;
	}

	@Override
	public void execute() {
		update();
	}

	@Override
	public void setQueryTimeout(int queryTimeout) {
		this.queryTimeout  = queryTimeout;
	}

	@Override
	public int getQueryTimeout() {
		return queryTimeout;
	}

	@Override
	public int update() {
		SqlPerformer sqlExec = session.sqlPerformer();
		sqlExec.setQueryTimeout(getQueryTimeout());
		return sqlExec.update(sql , generatedKeyReader, args);
	}

}
