package com.jpattern.orm.query.find;

import java.math.BigDecimal;
import java.util.List;

import com.jpattern.orm.exception.OrmException;
import com.jpattern.orm.exception.OrmNotUniqueResultException;
import com.jpattern.orm.query.LockMode;
import com.jpattern.orm.query.clause.OrmWhere;
import com.jpattern.orm.session.ResultSetReader;
import com.jpattern.orm.session.ResultSetRowReader;

/**
 * 
 * @author ufo
 *
 */
public class CustomFindWhereImpl extends OrmWhere<CustomFindWhere> implements CustomFindWhere {

	private final CustomFindQuery customFindQuery;

	@Override
	public String renderSql() {
		return this.customFindQuery.renderSql();
	}

	@Override
	public void renderSql(final StringBuilder stringBuilder) {
		this.customFindQuery.renderSql(stringBuilder);
	}

	@Override
	public void appendValues(final List<Object> values) {
		this.customFindQuery.appendValues(values);
	}

	public CustomFindWhereImpl(final CustomFindQuery customFindQuery) {
		this.customFindQuery = customFindQuery;
	}

	@Override
	public CustomFindQuery query() {
		return this.customFindQuery;
	}

	@Override
	protected CustomFindWhere where() throws OrmException {
		return this;
	}

	@Override
	public <T> T find(final ResultSetReader<T> rse) throws OrmException {
		return this.customFindQuery.find(rse);
	}

	@Override
	public CustomFindOrderBy orderBy() throws OrmException {
		return this.customFindQuery.orderBy();
	}

	@Override
	public List<Object[]> findList() throws OrmException {
		return this.customFindQuery.findList();
	}

	@Override
	public Object[] findUnique() throws OrmNotUniqueResultException {
		return this.customFindQuery.findUnique();
	}

	@Override
	public int findInt() throws OrmException {
		return this.customFindQuery.findInt();
	}

	@Override
	public long findLong() throws OrmException {
		return this.customFindQuery.findLong();
	}

	@Override
	public double findDouble() throws OrmException {
		return this.customFindQuery.findDouble();
	}

	@Override
	public float findFloat() throws OrmException {
		return this.customFindQuery.findFloat();
	}

	@Override
	public String findString() throws OrmException {
		return this.customFindQuery.findString();
	}

	@Override
	public boolean findBoolean() throws OrmException {
		return this.customFindQuery.findBoolean();
	}

	@Override
	public BigDecimal findBigDecimal() throws OrmException {
		return this.customFindQuery.findBigDecimal();
	}

	@Override
	public CustomFindQuery setLockMode(final LockMode lockMode) {
		return this.customFindQuery.setLockMode(lockMode);
	}

	@Override
	public LockMode getLockMode() {
		return this.customFindQuery.getLockMode();
	}

	@Override
	public int getMaxRows() throws OrmException {
		return this.customFindQuery.getMaxRows();
	}

	@Override
	public CustomFindQuery setMaxRows(final int maxRows) throws OrmException {
		return this.customFindQuery.setMaxRows(maxRows);
	}

	@Override
	public CustomFindQuery setQueryTimeout(final int queryTimeout) {
		return this.customFindQuery.setQueryTimeout(queryTimeout);
	}

	@Override
	public int getQueryTimeout() {
		return this.customFindQuery.getQueryTimeout();
	}

	@Override
	public CustomFindQuery setDistinct(final boolean distinct) throws OrmException {
		return this.customFindQuery.setDistinct(distinct);
	}

	@Override
	public boolean isDistinct() throws OrmException {
		return this.customFindQuery.isDistinct();
	}

	@Override
	public <T> List<T> find(final ResultSetRowReader<T> rsrr) throws OrmException {
		return this.customFindQuery.find(rsrr);
	}

	@Override
	public <T> T findUnique(final ResultSetRowReader<T> rsrr) throws OrmException, OrmNotUniqueResultException {
		return this.customFindQuery.findUnique(rsrr);
	}

}
