package com.jpattern.orm.query.find;

import com.jpattern.orm.exception.OrmException;
import com.jpattern.orm.query.BaseFindQuery;
import com.jpattern.orm.query.CustomQuery;
import com.jpattern.orm.query.LockMode;

/**
 * 
 * @author Francesco Cina
 *
 * 07/lug/2011
 */
public interface CustomFindQueryCommon extends BaseFindQuery, CustomQuery {

	/**
	 * Whether to use Distinct in the select clause
	 * @return
	 */
	CustomFindQuery setDistinct(boolean distinct) throws OrmException;

	/**
	 * return if use Distinct in the select clause
	 * @return
	 */
	boolean isDistinct() throws OrmException;

	/**
	 * 
	 * @param lockMode
	 * @return
	 */
	CustomFindQuery setLockMode(LockMode lockMode);

	/**
	 * Return the current lock mode
	 * @return
	 */
	LockMode getLockMode();

	/**
	 * Return the max rows for this query.
	 * @return
	 */
	int getMaxRows() throws OrmException;

	/**
	 * Set the maximum number of rows to return in the query.
	 * @param maxRows
	 * @return
	 */
	CustomFindQuery setMaxRows(int maxRows) throws OrmException;

	/**
	 * Set the query timeout for the query.
	 */
	CustomFindQuery setQueryTimeout(int queryTimeout);

	/**
	 * Return the query timeout for the query.
	 */
	int getQueryTimeout();

}
