package com.jpattern.orm.query.delete;

import java.util.List;

import com.jpattern.orm.query.clause.OrmWhere;

/**
 * 
 * @author ufo
 *
 */
public class DeleteWhereImpl extends OrmWhere<DeleteWhere> implements DeleteWhere {

	private final DeleteQuery deleteQuery;

	public DeleteWhereImpl(final DeleteQuery deleteQuery) {
		this.deleteQuery = deleteQuery;
	}

	@Override
	public String renderSql() {
		return this.deleteQuery.renderSql();
	}

	@Override
	public void renderSql(final StringBuilder stringBuilder) {
		this.deleteQuery.renderSql(stringBuilder);
	}

	@Override
	public void appendValues(final List<Object> values) {
		this.deleteQuery.appendValues(values);
	}

	@Override
	public DeleteQuery query() {
		return this.deleteQuery;
	}

	@Override
	protected DeleteWhere where() {
		return this;
	}

	@Override
	public int perform() {
		return this.deleteQuery.perform();
	}

	@Override
	public DeleteQuery setQueryTimeout(final int queryTimeout) {
		return this.deleteQuery.setQueryTimeout(queryTimeout);
	}

	@Override
	public int getQueryTimeout() {
		return this.deleteQuery.getQueryTimeout();
	}
}
