package com.jpattern.orm.query.delete;

import java.util.List;

import com.jpattern.orm.mapper.IOrmClassToolMap;
import com.jpattern.orm.persistor.type.TypeFactory;
import com.jpattern.orm.persistor.type.ext.WrapperTypeList;
import com.jpattern.orm.query.NameSolver;
import com.jpattern.orm.query.NameSolverConsumer;
import com.jpattern.orm.query.SmartRenderableSqlQuery;
import com.jpattern.orm.session.SessionSqlPerformer;
import com.jpattern.orm.session.SqlPerformer;

/**
 * 
 * @author Francesco Cina
 *
 * 10/lug/2011
 */
public class DeleteQueryOrm extends SmartRenderableSqlQuery implements DeleteQuery, NameSolverConsumer {

	private final DeleteWhereImpl where = new DeleteWhereImpl(this);
	private final IOrmClassToolMap ormClassToolMap;
	private final SessionSqlPerformer session;
	private int queryTimeout = 0;
	private final Class<?> clazz;
	private final TypeFactory typeFactory;

	public DeleteQueryOrm(final Class<?> clazz, final IOrmClassToolMap ormClassToolMap, final SessionSqlPerformer session, final TypeFactory typeFactory) {
		this.clazz = clazz;
		this.ormClassToolMap = ormClassToolMap;
		this.session = session;
		this.typeFactory = typeFactory;
	}

	@Override
	public DeleteWhere where() {
		return this.where;
	}

	@Override
	public int perform() {
		final List<Object> values = new WrapperTypeList(this.typeFactory);
		appendValues(values);
		final SqlPerformer sqlExec = this.session.sqlPerformer();
		sqlExec.setQueryTimeout(getQueryTimeout());
		return sqlExec.update(renderSql(), values);
	}

	@Override
	public final void appendValues(final List<Object> values) {
		this.where.appendElementValues(values);
	}

	@Override
	public DeleteQuery setQueryTimeout(final int queryTimeout) {
		this.queryTimeout = queryTimeout;
		return this;
	}

	@Override
	public int getQueryTimeout() {
		return this.queryTimeout;
	}

	@Override
	public void setNameSolver(final NameSolver nameSolver) {
		this.where.setNameSolver(nameSolver);
	}

	@Override
	public int getStatusVersion() {
		return this.where.getElementStatusVersion();
	};

	@Override
	public final void doRender(final StringBuilder stringBuilder) {
		stringBuilder.append("DELETE FROM ");
		stringBuilder.append(this.ormClassToolMap.getOrmClassTool(this.clazz).getClassMap().getTableInfo().getTableNameWithSchema() );
		stringBuilder.append(" ");
		this.where.renderSqlElement(stringBuilder);
	}

}
