package com.jpattern.orm.query.clause.where;

import java.util.List;

import com.jpattern.orm.query.BaseFindQuery;
import com.jpattern.orm.query.NameSolver;

/**
 * 
 * @author ufo
 *
 */
public abstract class SubQueryExpressionElement implements ExpressionElement {

	private final BaseFindQuery query;
	private NameSolver nameSolver;
	private final String property;
	private final String condition;

	public SubQueryExpressionElement(final String property, final BaseFindQuery query, final String condition) {
		this.property = property;
		this.query = query;
		this.condition = condition;
	}

	@Override
	public final String renderSqlElement() {
		StringBuilder StringBuilder = new StringBuilder();
		renderSqlElement(StringBuilder);
		return StringBuilder.toString();
	}

	@Override
	public final void renderSqlElement(final StringBuilder StringBuilder) {
		StringBuilder.append(  this.nameSolver.solvePropertyName( this.property ) );
		StringBuilder.append( this.condition );
		StringBuilder.append( "( ");
		this.query.renderSql(StringBuilder);
		StringBuilder.append(") ");
	}

	@Override
	public final void setNameSolver(final NameSolver nameSolver) {
		this.nameSolver = nameSolver;
	}

	@Override
	public final void appendElementValues(final List<Object> values) {
		this.query.appendValues(values);
	}
}
