package com.jpattern.orm.query.clause.where;

import java.util.List;

import com.jpattern.orm.query.NameSolver;

/**
 * 
 * @author Francesco Cina
 *
 * 26/giu/2011
 */
public class NotExpressionElement implements ExpressionElement {

	
	
	/**
	 * 
	 */
	
	protected final ExpressionElement expression;

	public NotExpressionElement(ExpressionElement expression) {
		this.expression = expression;
	}

	@Override
	public String renderSqlElement() {
		StringBuilder StringBuilder = new StringBuilder();
		renderSqlElement(StringBuilder);
		return StringBuilder.toString();
	}

	@Override
	public void renderSqlElement(StringBuilder StringBuilder) {
		StringBuilder.append("NOT ( ");
		expression.renderSqlElement(StringBuilder);
		StringBuilder.append(") ");
	}

	@Override
	public void setNameSolver(NameSolver nameSolver) {
		expression.setNameSolver(nameSolver);
	}

	@Override
	public final void appendElementValues(List<Object> values) {
		expression.appendElementValues(values);
	}

}