package com.jpattern.orm.query.clause.where;

import java.util.List;

import com.jpattern.orm.query.NameSolver;
import com.jpattern.orm.query.SmartRenderableSqlSubElement;

/**
 * 
 * @author Francesco Cina
 *
 * 26/giu/2011
 */
public abstract class MultipleExpressionElement extends SmartRenderableSqlSubElement implements ExpressionElement{

	private final String relationType;
	private final List<ExpressionElement> expressionElements;

	public MultipleExpressionElement(final String relationType, final List<ExpressionElement> expressionElements) {
		this.expressionElements = expressionElements;
		this.relationType = relationType;
	}

	@Override
	public final int getElementStatusVersion() {
		return 0;
	}

	@Override
	public final void doElementRender(final StringBuilder stringBuilder) {
		stringBuilder.append("( ");
		int last = this.expressionElements.size() - 1;
		if (last<0) {
			stringBuilder.append( "1=1 " );
		} else {
			for (int i=0; i<this.expressionElements.size(); i++) {
				this.expressionElements.get(i).renderSqlElement(stringBuilder);
				if (i!=last) {
					stringBuilder.append(this.relationType);
				}
			}
		}
		stringBuilder.append(") ");
	}

	@Override
	public void setNameSolver(final NameSolver nameSolver) {
		for (ExpressionElement expressionElement : this.expressionElements) {
			expressionElement.setNameSolver(nameSolver);
		}
	}

	@Override
	public final void appendElementValues(final List<Object> values) {
		for (ExpressionElement expressionElement : this.expressionElements) {
			expressionElement.appendElementValues(values);
		}
	}

}