package com.jpattern.orm.query.clause.where;

import java.util.List;

import com.jpattern.orm.exception.OrmQueryFormatException;
import com.jpattern.orm.query.NameSolver;
import com.jpattern.orm.query.NullNameSolver;
import com.jpattern.orm.query.SmartRenderableSqlSubElement;

/**
 * 
 * @author Francesco Cina
 *
 * 19/giu/2011
 */
public abstract class APropertiesExpressionElement extends SmartRenderableSqlSubElement  implements ExpressionElement {

	private final String firstProperty;
	private final String secondProperty;
	private NameSolver nameSolver = new NullNameSolver();

	public APropertiesExpressionElement(final String firstProperty, final String secondProperty) {
		this.firstProperty = firstProperty;
		this.secondProperty = secondProperty;
	}

	@Override
	public void setNameSolver(final NameSolver nameSolver) {
		this.nameSolver = nameSolver;
	}

	private PropertyDecorator propertyDecorator = new NullPropertyDecorator();
	private PropertyDecorator valueDecorator = new NullPropertyDecorator();

	protected NameSolver nameSolver() {
		return this.nameSolver;
	}

	protected PropertyDecorator getPropertyDecorator() {
		return this.propertyDecorator;
	}

	protected void setPropertyDecorator(final PropertyDecorator propertyDecorator) {
		this.propertyDecorator = propertyDecorator;
	}

	protected PropertyDecorator getValueDecorator() {
		return this.valueDecorator;
	}

	protected void setValueDecorator(final PropertyDecorator valueDecorator) {
		this.valueDecorator = valueDecorator;
	}

	@Override
	public final void doElementRender(final StringBuilder query) throws OrmQueryFormatException {
		query.append( getPropertyDecorator().decore( nameSolver().solvePropertyName(this.firstProperty) ) );
		query.append( " " );
		query.append( getExpressionElementKey() );
		query.append( " " );
		query.append( getPropertyDecorator().decore( nameSolver().solvePropertyName(this.secondProperty) ) );
		query.append( " " );
	}

	@Override
	public final int getElementStatusVersion() {
		return 0;
	}

	public abstract String getExpressionElementKey();


	@Override
	public final void appendElementValues(final List<Object> values) {
	}

}
